definition module EdProjectAux

/*	This module contains auxilary functions needed for the implementation of EdProject.
	The need for a seperate module arises from the fact that the Clean Linker complains about
	object file format size (> 32K).
*/

import EdTypes, EdMyIO, EdPath

//	First element of InfList (if any) is the root module.

::	InfList		:==	List InfListItem
	
::	InfListItem	=	{	mn		:: !Modulename, 
						info	:: !ModInfo,
						src		:: !Bool,
						abc		:: !Bool }
	// module name, ,module info, src up to date?, abc up to date?

::	InfUpdate 	:== InfListItem -> (!InfListItem, !Bool)

EmtyModInfo :: ModInfo
P_MapR :: !(s -> (!t,!Bool)) !(List s) -> (!List t,!Bool)
RemoveUnusedModules :: !InfList -> InfList
UpdateList :: !String InfUpdate !InfList -> (!InfList,!Bool)
FindInList	:: !String !InfList -> (!Bool, !InfListItem)
TryInsertInList :: !String !(List String) !InfList -> (!InfList,!Bool)

instance == ModInfo
instance == EditOptions
instance == CompilerOptions
instance == CodeGenOptions
instance == ApplicationOptions
instance == ProjectOptions
instance == LinkOptions
